/*
*	Author:				Niklas Menke - https://www.niklas-menke.de/ (GE)
*	Description:		This library uses the USI (Universal Serial Interface) to provide a UART. Also there are some supportive routines.
*
*	File:				usi-uart.h
*	Description:		Functions declaration
*	Microcontroller:	Attiny861A@8MHz; No other microcontrollers were tested
*	Date (created):		Mar 10, 2021
*
*	Version (Hardware):	-
*	Version (Software):	1.1.0
*	Date (updated):		Jan 16, 2022
*	Change log:			1.0.0
*							- First release
*						1.1.0
*							- Added function to return the current status of the UART
*	ToDo:				- (Ideas or Problems? --> https://www.niklas-menke.de/kontakt/ (GE))
*
*
*	WARNING!:	This code was only test with the Attiny861A controller and a CPU frequency of 8MHz. Support is not guaranteed for other conditions!
*				To get a CPU frequency of 8MHz, you have to clear the clock divider fuse (LOW.CKDIV8).
*/


#ifndef USI_UART_H_
#define USI_UART_H_


#include <avr/io.h>
#include <avr/interrupt.h>


// Status codes
#define USI_UART_STOP	0x00
#define USI_UART_READY	0x01
#define USI_UART_RX		0x02
#define USI_UART_TX		0x03


uint8_t uart_status(void);	// Return the current status of the UART

void uart_listen(void);	// Monitor DI pin for incoming bytes
void uart_stop(void);	// Stop monitoring DI pin for incoming bytes

uint16_t uart_getBaudrate(void);	// Return baud rate from the pin header
void uart_TimerConfig(void);		// Calculate timer setpoint and prescaler

void uart_receive(void);											// Receive one byte
void uart_transmit(const uint8_t byte);								// Transmit one byte
void uart_transmitArray(const uint8_t *byte, const uint8_t length);	// Transmit an array of bytes

uint8_t uart_available(void);	// Return number of received bytes in buffer
uint8_t uart_readByte(void);	// Return first byte from buffer without delete them from buffer
uint8_t uart_getByte(void);		// Return first byte from buffer and delete them from buffer
void uart_delete(void);			// Clear buffer

uint8_t rev_byte(uint8_t rbyte);	// Reverse bits of a byte


#endif /* USI_UART_H_ */